/*------------------------------------------------------------------------------
BOD test.C - adapted for the P89LPC98x 
Demonstration for Enhanced BOD of LPC98x
Copyright NXP Semiconductors.
Rev.01, 2009 Jun 25.
Rev.02, 2010 Mar 10. 
------------------------------------------------------------------------------*/

#include "REG98x.H"         // special function register declarations 
                            // for the NXP P89LPC98x device  
#include <stdio.h>          // prototype declarations for I/O functions 

char BOD_flag;					 

static void delay (void)  	 // delay of 0.2 sec
{
  unsigned long i;

  for (i = 0; i < 25000; i++);	// loop for delay  
}

/*--------------------------------------------------
The BOD Interrupt Function Config. 
RST voltage is set to 2.25V Fall and 2.4V Rise by setting UCFG1, 
when programming the uController.
The Interrupt Voltage could be set to 2.55V Fall and 2.7V Rise by this function
----------------------------------------------------*/

void BOD_Int_Config(void)
{
	BODCFG = 0x02;    // set BODCFG = 0000 0010 bin: the BOD int voltage is 2.55V fall and 2.7V rise	
	EA = 1;           // set Enable all interrupts
	EBO = 1;          // set BOD enable  
	PCON |=0x10;      // set BOD interrupt enable 

		printf ("Setting BODCFG = 0000 0010 \n");    
		printf ("Setting completed! BOD interrupt voltage is 2.55V Fall and 2.7V Rise.\n");   
}


/*------------------------------------------------
BOD interrupt routine.
------------------------------------------------*/
void BOD_ISR(void) interrupt 5
{
	RSTSRC &= ~0x40;	// clr BOIF at RSTSRC.6
	
	BOD_flag = 1;		// make flag active	
	
	P2^=0xff;         // Blinky LEDs
}

/*------------------------------------------------
The main C function.  Program execution starts
here after stack initialization.
------------------------------------------------*/
void main() 
{
  	unsigned char a;

  	P2M1 = 0;
  	P1M1 = 0;

  	SCON   = 0x52;    // initialize UART 
  	BRGR0  = 0xF0;    // 9600 baud, 8 bit, no parity, 1 stop bit 
  	BRGR1  = 0x02;
  	BRGCON = 0x03;
 
        P2=0x55;
 	
 
 		printf ("-------------------------------------------------------------------\n");  
 		printf ("Hello! \n");   
 		printf ("This is a BOD test program for NXP MCU LPC98x\n");    
 		printf ("Reading the original UCFG1 configuration after reset, please wait... \n");    
 		printf ("-------------------------------------------------------------------\n");   

  	a = BODCFG;               
  	
	// Print UCFG1.5 to 1.3, which are loaded to BODCFG during reset
	switch(a)
	{
		case 0x02:   printf("UCFG1.5 to 1.3 = 010 \n"); break;
      case 0x03:   printf("UCFG1.5 to 1.3 = 011 \n"); break;
      case 0x04:   printf("UCFG1.5 to 1.3 = 100 \n"); break;
      case 0x05:   printf("UCFG1.5 to 1.3 = 101 \n"); break;
      case 0x06:   printf("UCFG1.5 to 1.3 = 110 \n"); break;
		case 0x07:   printf("UCFG1.5 to 1.3 = 111 \n"); break;
	}	
	printf ("\n"); 	// extra line feed 
	  
	printf ("For testing: please adjust the LPC98x Vdd to below 2.55V... and wait for the alarm...\n");    
	
	BOD_Int_Config();	// Initialize BOD interrupt
	
	printf ("\n"); 	// extra line feed  

  	while(1)        	// Please adjust the Vdd gently from 3.0V to < 2.7V, and wait for the BOD interrupt
	{
	 	if (BOD_flag == 1)
		{
		 	BOD_flag = 0;		// reset flag

			printf ("\n");    // print BOD interrupt information
			printf ("BOD interrupt! Please note the voltage! \n");   
			printf ("\n");                                            
		} 
		delay();				// delay of 0.2 sec
	}	// end of while								
}	// end of main

